constant kRecentsSoupName := "HyperNewt Recents";	
	
/* kHyperIndexSoupDef
 * ------------------
 * Soup definition for the union soup that will contain all of the
 * directories. We index the entries on the slot 'directoryID and
 * the multiSlot, [ 'parentID, 'title ].
 *
 */

DefConst('kRecentsSoupDef,
	{	name: kRecentsSoupName,
		userName: "HN Recents",
		ownerApp: kAppSymbol,
		ownerAppName: kAppName,
		userDescr: "This soup is used by" && kAppName,
		indexes:	[ { structure: 'slot, path: 'class, type: 'symbol }, ],
  }
);


DefConst('kRecentsPickActionScript, func(itemSelected)
begin
	local recent := ResolveEntryAlias(labelCommands[itemSelected].alias);
		
	if itemSelected = Length(self.labelCommands) - 2 then begin
		local recentsSoup := GetUnionSoupAlways(kRecentsSoupName);
		local cursor := recentsSoup:Query({ type: 'index, validTest: func(recent) not recent.favorite } );
		local e := cursor:entry();
		
		while e do begin
			entryremovefromsoup(e);
			e := cursor:reset();
		end;
	end;
	else if itemSelected = Length(self.labelCommands) - 1 then begin
		local recentsSoup := GetUnionSoupAlways(kRecentsSoupName);
		local cursor := recentsSoup:Query({ type: 'index, validTest: func(recent) recent.favorite } );
		local e := cursor:entry();
		
		while e do begin
			entryremovefromsoup(e);
			e := cursor:reset();
		end;
	end;
	else begin
		if recent then begin
			local class := ClassOf(recent);
			local directory;
			
			if class = kDirectoryDataSymbol then :GotoDirectory(recent.directoryID);
			else if class = kHLDataSymbol then :GotoHyperLink(recent, nil);
			else if :PrefsLookup('displayWithNotepad) and not :PrefsLookup('replaceNotepad) then
				:DefaultShowHyperLink(recent, 'paperroll);
			else begin
				try	if :GotoDirectory(recent.(kAppSymbol).parentID) then newtAppBase:ShowFoundItem(recent, {})
				onexception |evt.ex| do nil;
			end;
		end;
		else GetRoot():Notify(kNotifyAlert, kAppTitle, LocObj("", '[pathExpr: messages, recentNotFound]));
	end;
	inherited:?pickActionScript(itemSelected);		// this method is defined internally
end);


DefConst('kRecentsPopupSetupFunc, func() begin
	local recentsSoup := GetUnionSoupAlways(kRecentsSoupName);
	local cursor := recentsSoup:Query({type: 'index, indexPath: 'class});
	local recent := cursor:entry();
	local entry, dataDef, class, title, icon;
	local removeArr := [];
	local recentItem;
	local lastClass;
	local dataDef := GetDataDefs(kHLDataSymbol);
		
	self.labelCommands := [];
		
	while recent do begin
		entry := ResolveEntryAlias(recent.alias);
		
		if entry then begin
			class := ClassOf(recent);
			
			if lastClass and (class = kDirectoryDataSymbol and lastClass <> kDirectoryDataSymbol) or
			   (class = kHLDataSymbol and lastClass <> kHLDataSymbol) or
			   (class = 'stationery and lastClass <> 'stationery) then AddArraySlot(labelCommands, 'pickSeparator);
			lastClass := Clone(class);
			
			if class = kDirectoryDataSymbol then begin
				icon := kDirectoryIcon;
				title := Clone(entry.title);
			end;
			else if class = kHLDataSymbol then begin
				title := dataDef:StringExtract(entry, 1);
				icon := dataDef:IconExtract(entry);
			end;
			else begin
				dataDef := GetEntryDataDef(entry);
				icon := datadef.icon;
				title := datadef:?stringExtract(entry, 1);
			end;
			
			if recent.favorite then
				title := "" && title;
				
			AddArraySlot(labelCommands, { icon: icon, indent: 30, item: title, alias: recent.alias });
		end;
		else AddArraySlot(removeArr, recent);
		
		recent := cursor:next();
	end;
	
	if Length(labelCommands) <> 0 then begin
		AddArraySlot(labelCommands, 'pickSeparator);
		AddArraySlot(labelCommands, { icon: kClearIcon, indent: 30, item: LocObj("",'[pathExpr: recents, clear]) });
		AddArraySlot(labelCommands, { icon: kClearIcon, indent: 30, item: LocObj("",'[pathExpr: recents, clearFavorites]) });
	end;
	
	if Length(labelCommands) > 0 and labelCommands[0] = 'pickSeparator then RemoveSlot(labelCommands, 0);

	foreach recent in removeArr do begin
		if not recent.favorite then
			EntryRemoveFromSoup(recent);
	end;
	
	if :PrefsLookup('showRecentsButton) then begin
		self.popup := labelCommands;
		inherited:?ButtonClickScript();
	end;
	else labelCommands;
end);
